-- examples of arguments

CREATE OR REPLACE FUNCTION hello_world (
  OUT greetings text
) AS
$$
  select 'hello world'::text;
$$
LANGUAGE SQL;

/*
select hello_world();
select * from hello_world();
*/

CREATE OR REPLACE FUNCTION echo(text) RETURNS TEXT AS $$ select $1 $$ LANGUAGE SQL;

/*
select * from echo('Rob');
*/


CREATE OR REPLACE FUNCTION echo (
  IN  str_in    text,
  OUT str_out   text
) AS
$$
  select $1;
$$
LANGUAGE SQL;

/*
select * from echo('Robert');
*/

CREATE OR REPLACE FUNCTION echo (
  IN  str_in    text,
  OUT str_out   text
) AS
$$
  select str_in;
$$
LANGUAGE SQL;

/*
select * from echo('Robert');
*/

DROP FUNCTION IF EXISTS echo(text);

CREATE OR REPLACE FUNCTION echo (
  INOUT str_inout text
) AS
$$
  select str_inout;
$$
LANGUAGE SQL;

/*
select * from echo('Robert Bernier');
*/
